/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.mixin.client;

import me.angel.challenges6t4.challenge.Challenges;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class})
public class UltraHeatMixin {
    private class_243 prevPlayerPos = null;
    private float prevPlayerYaw = 0.0f;
    private float prevPlayerPitch = 0.0f;
    private float currentTickSpeed = 1.0f;
    private int tickCounter = 0;
    private int slowTickCounter = 0;
    private boolean isInitialized = false;
    private int startupTicks = 0;
    private static final int STARTUP_DELAY_TICKS = 60;

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTick(CallbackInfo ci) {
        float cameraMovement;
        class_310 client = (class_310)this;
        if (client.field_1687 == null || !Challenges.ULTRA_HEAT.isEnabled()) {
            this.currentTickSpeed = 1.0f;
            this.isInitialized = false;
            this.startupTicks = 0;
            return;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        if (!this.isInitialized) {
            ++this.startupTicks;
            if (this.startupTicks < 60) {
                this.currentTickSpeed = 1.0f;
                this.updateTracking((class_1657)player);
                return;
            }
            this.isInitialized = true;
            this.prevPlayerPos = player.method_19538();
            this.prevPlayerYaw = player.method_36454();
            this.prevPlayerPitch = player.method_36455();
        }
        if (player.method_29504() || player.method_6113() || player.method_7325()) {
            this.currentTickSpeed = 1.0f;
            this.updateTracking((class_1657)player);
            return;
        }
        float movementSpeed = this.calculateMovementSpeed((class_1657)player);
        float desiredTickSpeed = Challenges.ULTRA_HEAT.calculateTickSpeed(movementSpeed, cameraMovement = this.calculateCameraMovement((class_1657)player));
        if (desiredTickSpeed <= 0.0f) {
            ci.cancel();
            return;
        }
        this.currentTickSpeed = this.lerp(this.currentTickSpeed, desiredTickSpeed, 0.1f);
        ++this.tickCounter;
        if (this.currentTickSpeed < 0.8f) {
            ++this.slowTickCounter;
            int skipFrequency = Math.max(1, (int)(5.0f * (1.0f - this.currentTickSpeed)));
            if (this.slowTickCounter % skipFrequency != 0) {
                ci.cancel();
                return;
            }
        }
        this.updateTracking((class_1657)player);
    }

    private float calculateMovementSpeed(class_1657 player) {
        if (this.prevPlayerPos == null) {
            this.prevPlayerPos = player.method_19538();
            return 0.0f;
        }
        class_243 currentPos = player.method_19538();
        double distance = this.prevPlayerPos.method_1022(currentPos);
        float normalizedSpeed = (float)Math.min(distance / 0.2, 1.0);
        return normalizedSpeed;
    }

    private float calculateCameraMovement(class_1657 player) {
        float yawDiff = Math.abs(player.method_36454() - this.prevPlayerYaw);
        float pitchDiff = Math.abs(player.method_36455() - this.prevPlayerPitch);
        if (yawDiff > 180.0f) {
            yawDiff = 360.0f - yawDiff;
        }
        float totalRotation = yawDiff + pitchDiff;
        float normalizedRotation = Math.min(totalRotation / 3.0f, 1.0f);
        return normalizedRotation;
    }

    private void updateTracking(class_1657 player) {
        this.prevPlayerPos = player.method_19538();
        this.prevPlayerYaw = player.method_36454();
        this.prevPlayerPitch = player.method_36455();
    }

    private float lerp(float a, float b, float t) {
        return a + t * (b - a);
    }
}

